/**************************************************************************************

Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.

***************************************************************************************

  $Id:  $:

  Description:
    Implementation of the CifX Device base class,
    for accessing System Device and channel via the same functions

  Changes:
    Date        Description
    -----------------------------------------------------------------------------------
    2006-06-28  initial version

**************************************************************************************/

#include "StdAfx.h"
#include ".\cifxdevicebase.h"
#include "cifXTest.h"
#include "CifXTestDlg.h"

///////////////////////////////////////////////////////////////////////////////////////////
/// \file CifxDeviceBase.cpp
///  Implementation of the CifX Device base class
///////////////////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
/// Constructor
///   \param ptBoardInfo    Pointer to board information from driver
///   \param ptChannelInfo  Pointer to channel information from driver
/////////////////////////////////////////////////////////////////////////////
CCifXDeviceBase::CCifXDeviceBase(BOARD_INFORMATION* ptBoardInfo, CHANNEL_INFORMATION* ptChannelInfo, CCifXAPIlib* pcCifXAPI)
:m_pcCifXAPI(pcCifXAPI)
{
  if(ptBoardInfo)
    m_tBoardInfo = *ptBoardInfo;
  else
    ZeroMemory(&m_tBoardInfo, sizeof(m_tBoardInfo));

  if(ptChannelInfo)
    m_tChannelInfo = *ptChannelInfo;
  else
    ZeroMemory(&m_tChannelInfo, sizeof(m_tChannelInfo));
}

/////////////////////////////////////////////////////////////////////////////
/// Destructor
/////////////////////////////////////////////////////////////////////////////
CCifXDeviceBase::~CCifXDeviceBase(void)
{
}

/////////////////////////////////////////////////////////////////////////////
/// Get the device specific properties
///   \return Array of all property/value pairs
/////////////////////////////////////////////////////////////////////////////
std::vector<CCifXDeviceBase::PROPERTY_LIST> CCifXDeviceBase::GetDescription(void)
{
  std::vector<CCifXDeviceBase::PROPERTY_LIST> cvList;

  PROPERTY_LIST tList;

  tList.csProperty = _T("Physical Address");
  tList.csValue.Format(_T("0x%08X"), m_tBoardInfo.ulPhysicalAddress);
  cvList.push_back(tList);

  tList.csProperty = _T("Interrupt");
  tList.csValue.Format(_T("%u"), m_tBoardInfo.ulIrqNumber);
  cvList.push_back(tList);

  if(CIFX_NO_ERROR != m_tBoardInfo.lBoardError)
  {
    tList.csProperty = _T("Board Error (Code)");
    tList.csValue.Format(_T("0x%08X"),
                         m_tBoardInfo.lBoardError);
    cvList.push_back(tList);

    tList.csProperty = _T("Board Error (Descr.)");
    tList.csValue.Format(_T("%s"),
                         GetErrorDescription(m_tBoardInfo.lBoardError));
    cvList.push_back(tList);

  } else
  {
    tList.csProperty = _T("Device Number");
    tList.csValue.Format(_T("%u"), m_tBoardInfo.tSystemInfo.ulDeviceNumber);
    cvList.push_back(tList);

    tList.csProperty = _T("Serial Number");
    tList.csValue.Format(_T("%u"), m_tBoardInfo.tSystemInfo.ulSerialNumber);
    cvList.push_back(tList);
  }

  tList.csProperty = _T("DPM Size");
  tList.csValue.Format(_T("%u"), m_tBoardInfo.ulDpmTotalSize);
  cvList.push_back(tList);

  return cvList;
}
